//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "ALMUseCase.h"

@implementation ALMUseCase: NSObject

#pragma mark - sharedInstance
+ (ALMUseCase *) sharedInstance
{
    static ALMUseCase *sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{ sharedInstance = [[ALMUseCase alloc] init]; });
    return sharedInstance;
}

#pragma mark - readALM
- (void) readALM:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    ISO15693Command *readALMConfiguration = [[ISO15693Command alloc] initWithData:cmd_readALMConfiguration];
    
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readALMConfiguration onSuccess:^(NSData *aData){
        success(aData);
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_tag_correctly_read];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {
            NSLog(@"readALM error :\n%@", error.localizedDescription);
        }];
    } onFailure:^(NSError *error) {
        NSLog(@"readALM error :\n%@", error.localizedDescription);
    }];
}
@end
